require( "scripts/style.lua" );

kButtonStart = 130;
kButtonSpace = 40;
MakeDialog
{
    PopThroughBitmap
    {
        name="yesnobackground",
		image="backgrounds/longdialog",
		x=kCenter,
		y=kCenter,
        
        Button
		{
			x=kCenter,
			y=kButtonStart + (kButtonSpace * 0),
			font = OptionFont,
			graphics = SolidButtonGraphics,
			name="careereditor",
			label="careereditor",
			type = kPush,
			xoffset = 1,
			yoffset = 1,
			command=
				function()
					SetLevelMode(0);
					SetCurrentGameMode(0);
					CloseAllWindows();
					DoModal("scripts/leveleditor/leveleditor.lua");
				end
		},
		
		Button
		{
			x=kCenter,
			y=kButtonStart + (kButtonSpace * 1),
			font = OptionFont,
			graphics = SolidButtonGraphics,
			name="endlesseditor",
			label="endlesseditor",
			type = kPush,
			xoffset = 1,
			yoffset = 1,
			command=
				function()
					SetLevelMode(0);
					SetCurrentGameMode(1);
					CloseAllWindows();
					DoModal("scripts/leveleditor/leveleditor.lua");
				end
		},
		
		Button
		{
			x=kCenter,
			y=kButtonStart + (kButtonSpace * 2),
			font = OptionFont,
			graphics = SolidButtonGraphics,
			name="bonuseditor",
			label="le_extraeditor",
			type = kPush,
			xoffset = 1,
			yoffset = 1,
			command=
				function()
					SetLevelMode(1);
					SetCurrentGameMode(0);
					SetOneOffLevelName("");
					name = DoModal("scripts/leveleditor/expertlevel.lua");
					if (not(name == nil)) then
						SetOneOffLevelName("assets/"..GetRestaurantFolder(name).."/levels/expertlevel.xml");
						CloseAllWindows();
						DoModal("scripts/leveleditor/leveleditor.lua");
					end
				end
		},
		
		
		Button
		{
			x=kCenter,
			y=kButtonStart + (kButtonSpace * 3),
			font = OptionFont,
			graphics = SolidButtonGraphics,
			name="mpeditor",
			label="le_mpeditor",
			type = kPush,
			xoffset = 1,
			yoffset = 1,
			command=
				function()
					SetLevelMode(2);
					SetCurrentGameMode(1);
					SetOneOffLevelName("");
					name = DoModal("scripts/leveleditor/leveleditorname.lua");
					if (not(name == nil)) then
						SetOneOffLevelName("downloads/"..name..".xml");
						SetMultiplayerLevelTestMode(true);
						CloseAllWindows();
						DoModal("scripts/leveleditor/leveleditor.lua");
					end
				end
		},
		
		
		
		Button
		{
			x=kCenter,
			y=kButtonStart + (kButtonSpace * 4),
			font = OptionFont,
			graphics = SolidButtonGraphics,
			name="customereditor",
			label="customereditor",
			type = kPush,
			xoffset = 1,
			yoffset = 1,
			command=
				function()
					SetLevelMode(0);
					SetCurrentGameMode(1);
					CloseAllWindows();
					DoModal("scripts/leveleditor/customereditor.lua");
				end
		},
		
		Button
		{
			x=kCenter,
			y=kButtonStart + (kButtonSpace * 5),
			font = OptionFont,
			graphics = SolidButtonGraphics,
			name="back",
			label="back",
			type = kPush,
			xoffset = 1,
			yoffset = 1,
			command=
				function()
					PopModal("scripts/leveleditor/editors.lua");
				end
		},
    },

} -- MakeDialog
